/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { ifDefined } from 'lit/directives/if-defined.js';
import { classMap } from 'lit/directives/class-map.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import FocusMixin from '../../globals/mixins/focus.js';
import styles from './header.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Header nav item.
 *
 * @element cds-header-nav-item
 * @csspart link The link.
 * @csspart title The title.
 */
let CDSHeaderNavItem = class CDSHeaderNavItem extends FocusMixin(LitElement) {
    constructor() {
        super(...arguments);
        /**
         * Applies selected styles to the item if a user sets this to true and `aria-current !== 'page'`.
         */
        this.isActive = false;
        /**
         * As child of <ul>, this element must have role of listitem
         */
        this.role = 'listitem';
    }
    render() {
        const { ariaCurrent, href, isActive, title, rel, target } = this;
        const linkClass = classMap({
            [`${prefix}--header__menu-item`]: true,
            [`${prefix}--header__menu-item--current`]: isActive && ariaCurrent !== 'page',
        });
        return html `
      <a
        part="link"
        class="${linkClass}"
        tabindex="0"
        href="${ifDefined(href)}"
        rel="${ifDefined(rel)}"
        target="${ifDefined(target)}">
        <span part="title" class="${prefix}--text-truncate--end"
          ><slot>${title}</slot></span
        >
      </a>
    `;
    }
};
CDSHeaderNavItem.shadowRootOptions = Object.assign(Object.assign({}, LitElement.shadowRootOptions), { delegatesFocus: true });
CDSHeaderNavItem.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property()
], CDSHeaderNavItem.prototype, "href", void 0);
__decorate([
    property({ reflect: true })
], CDSHeaderNavItem.prototype, "rel", void 0);
__decorate([
    property({ reflect: true })
], CDSHeaderNavItem.prototype, "target", void 0);
__decorate([
    property()
], CDSHeaderNavItem.prototype, "title", void 0);
__decorate([
    property({ type: Boolean, attribute: 'is-active' })
], CDSHeaderNavItem.prototype, "isActive", void 0);
__decorate([
    property({ type: String, attribute: 'aria-current' })
], CDSHeaderNavItem.prototype, "ariaCurrent", void 0);
__decorate([
    property({ reflect: true })
], CDSHeaderNavItem.prototype, "role", void 0);
CDSHeaderNavItem = __decorate([
    carbonElement(`${prefix}-header-nav-item`)
], CDSHeaderNavItem);
var CDSHeaderNavItem$1 = CDSHeaderNavItem;

export { CDSHeaderNavItem$1 as default };
//# sourceMappingURL=header-nav-item.js.map
