/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import styles from './header.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Header.
 *
 * @element cds-header-nav
 * @csspart menu-body The menu body.
 * @csspart divider The divider.
 */
let CDSHeaderNav = class CDSHeaderNav extends LitElement {
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'navigation');
        }
        super.connectedCallback();
    }
    render() {
        const { menuBarLabel } = this;
        return html `
      <div part="divider" class="${prefix}-ce--header__divider"></div>
      <ul
        part="menu-body"
        class="${prefix}--header__menu-bar"
        aria-label="${menuBarLabel}">
        <slot></slot>
      </ul>
    `;
    }
};
CDSHeaderNav.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ attribute: 'menu-bar-label' })
], CDSHeaderNav.prototype, "menuBarLabel", void 0);
CDSHeaderNav = __decorate([
    carbonElement(`${prefix}-header-nav`)
], CDSHeaderNav);
var CDSHeaderNav$1 = CDSHeaderNav;

export { CDSHeaderNav$1 as default };
//# sourceMappingURL=header-nav.js.map
