/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import styles from './header.scss.js';
import { prefix } from '../../globals/settings.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2023, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Header panel
 *
 * @element cds-header-panel
 */
let CDSHeaderPanel = class CDSHeaderPanel extends LitElement {
    render() {
        return html `<slot></slot>`;
    }
};
CDSHeaderPanel.shadowRootOptions = Object.assign(Object.assign({}, LitElement.shadowRootOptions), { delegatesFocus: true });
CDSHeaderPanel.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ type: Boolean, reflect: true })
], CDSHeaderPanel.prototype, "expanded", void 0);
CDSHeaderPanel = __decorate([
    carbonElement(`${prefix}-header-panel`)
], CDSHeaderPanel);
var CDSHeaderPanel$1 = CDSHeaderPanel;

export { CDSHeaderPanel$1 as default };
//# sourceMappingURL=header-panel.js.map
