/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { prefix } from '../../globals/settings.js';
import styles from './side-nav.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2023, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Header Side Nav Items section
 *
 * @element cds-header-side-nav-items
 */
let CDSHeaderSideNavItems = class CDSHeaderSideNavItems extends LitElement {
    constructor() {
        super(...arguments);
        /**
         * Optionally specify if container will have a bottom divider to differentiate
         * between original sidenav items and header menu items. False by default.
         */
        this.hasDivider = false;
    }
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'list');
        }
        super.connectedCallback();
    }
    render() {
        return html `<slot></slot>`;
    }
};
CDSHeaderSideNavItems.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ type: Boolean, attribute: 'has-divider' })
], CDSHeaderSideNavItems.prototype, "hasDivider", void 0);
CDSHeaderSideNavItems = __decorate([
    carbonElement(`${prefix}-header-side-nav-items`)
], CDSHeaderSideNavItems);
var CDSHeaderSideNavItems$1 = CDSHeaderSideNavItems;

export { CDSHeaderSideNavItems$1 as default };
//# sourceMappingURL=header-side-nav-items.js.map
