/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import styles from './header.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Header.
 *
 * @element cds-header
 */
let CDSHeader = class CDSHeader extends LitElement {
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'banner');
        }
        super.connectedCallback();
    }
    render() {
        return html ` <slot></slot> `;
    }
};
CDSHeader.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
CDSHeader = __decorate([
    carbonElement(`${prefix}-header`)
], CDSHeader);
var CDSHeader$1 = CDSHeader;

export { CDSHeader$1 as default };
//# sourceMappingURL=header.js.map
