/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement } from 'lit';
import { prefix } from '../../globals/settings.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import styles from './side-nav.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2021, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * A divider in side nav.
 *
 * @element cds-side-nav-divider
 */
let CDSSideNavDivider = class CDSSideNavDivider extends LitElement {
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'separator');
        }
        super.connectedCallback();
    }
};
CDSSideNavDivider.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
CDSSideNavDivider = __decorate([
    carbonElement(`${prefix}-side-nav-divider`)
], CDSSideNavDivider);
var CDSSideNavDivider$1 = CDSSideNavDivider;

export { CDSSideNavDivider$1 as default };
//# sourceMappingURL=side-nav-divider.js.map
