/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { prefix } from '../../globals/settings.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import styles from './side-nav.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Side nav items.
 *
 * @element cds-side-nav-items
 */
let CDSSideNavItems = class CDSSideNavItems extends LitElement {
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'list');
        }
        super.connectedCallback();
    }
    render() {
        return html `<slot></slot>`;
    }
};
CDSSideNavItems.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
CDSSideNavItems = __decorate([
    carbonElement(`${prefix}-side-nav-items`)
], CDSSideNavItems);
var CDSSideNavItems$1 = CDSSideNavItems;

export { CDSSideNavItems$1 as default };
//# sourceMappingURL=side-nav-items.js.map
