/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { ifDefined } from 'lit/directives/if-defined.js';
import { LitElement, html } from 'lit';
import { query, property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import FocusMixin from '../../globals/mixins/focus.js';
import styles from './side-nav.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Side nav menu item.
 *
 * @element cds-side-nav-link
 * @slot link - The link.
 * @slot title - The title.
 * @slot title-icon-container - The title icon container.
 */
let CDSSideNavLink = class CDSSideNavLink extends FocusMixin(LitElement) {
    constructor() {
        super(...arguments);
        /**
         * `true` if the menu item should be active.
         */
        this.active = false;
        /**
         * Link `href`.
         */
        this.href = '';
        /**
         * Specify if this is a large variation of the side nav link
         */
        this.large = false;
    }
    /**
     * Handles `slotchange` event on the `<slot>` for the title icon.
     */
    _handleSlotChangeTitleIcon({ target }) {
        var _a;
        (_a = this._titleIconContainerNode) === null || _a === void 0 ? void 0 : _a.toggleAttribute('hidden', target.assignedNodes().length === 0);
    }
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'listitem');
        }
        super.connectedCallback();
    }
    render() {
        const { active, href, rel, target, title, _handleSlotChangeTitleIcon: handleSlotChangeTitleIcon, } = this;
        const classes = classMap({
            [`${prefix}--side-nav__link`]: true,
            [`${prefix}--side-nav__link--current`]: active,
        });
        return html `
      <a
        part="link"
        class="${classes}"
        href="${href}"
        rel="${ifDefined(rel)}"
        target="${ifDefined(target)}">
        <div
          id="title-icon-container"
          part="title-icon-container"
          hidden
          class="${prefix}--side-nav__icon">
          <slot
            name="title-icon"
            @slotchange=${handleSlotChangeTitleIcon}></slot>
        </div>
        <span part="title" class="${prefix}--side-nav__link-text">
          <slot>${title}</slot>
        </span>
      </a>
    `;
    }
};
CDSSideNavLink.shadowRootOptions = Object.assign(Object.assign({}, LitElement.shadowRootOptions), { delegatesFocus: true });
CDSSideNavLink.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    query('#title-icon-container')
], CDSSideNavLink.prototype, "_titleIconContainerNode", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSSideNavLink.prototype, "active", void 0);
__decorate([
    property()
], CDSSideNavLink.prototype, "href", void 0);
__decorate([
    property({ reflect: true })
], CDSSideNavLink.prototype, "rel", void 0);
__decorate([
    property({ reflect: true })
], CDSSideNavLink.prototype, "target", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSSideNavLink.prototype, "large", void 0);
__decorate([
    property()
], CDSSideNavLink.prototype, "title", void 0);
CDSSideNavLink = __decorate([
    carbonElement(`${prefix}-side-nav-link`)
], CDSSideNavLink);
var CDSSideNavLink$1 = CDSSideNavLink;

export { CDSSideNavLink$1 as default };
//# sourceMappingURL=side-nav-link.js.map
