/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { prefix } from '../../globals/settings.js';
import FocusMixin from '../../globals/mixins/focus.js';
import styles from './side-nav.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2023
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Side nav menu item.
 *
 * @element cds-side-nav-menu-item
 * @csspart link The link.
 * @csspart title The title.
 */
let CDSSideNavMenuItem = class CDSSideNavMenuItem extends FocusMixin(LitElement) {
    constructor() {
        super(...arguments);
        /**
         * `true` if the menu item should be active.
         */
        this.active = false;
        /**
         * Link `href`.
         */
        this.href = '';
    }
    shouldUpdate(changedProperties) {
        if (changedProperties.has('active') && this.active) {
            const { selectorMenu } = this.constructor;
            const parent = this.closest(selectorMenu);
            if (parent) {
                parent.active = true;
            }
        }
        return true;
    }
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'button');
        }
        super.connectedCallback();
    }
    render() {
        const { active, href, title } = this;
        const classes = classMap({
            [`${prefix}--side-nav__link`]: true,
            [`${prefix}--side-nav__link--current`]: active,
        });
        return html `
      <a part="link" class="${classes}" href="${href}">
        <span part="title" class="${prefix}--side-nav__link-text">
          <slot>${title}</slot>
        </span>
      </a>
    `;
    }
    /**
     * A selector that will return the parent menu.
     */
    static get selectorMenu() {
        return `${prefix}-side-nav-menu`;
    }
};
CDSSideNavMenuItem.shadowRootOptions = Object.assign(Object.assign({}, LitElement.shadowRootOptions), { delegatesFocus: true });
CDSSideNavMenuItem.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ type: Boolean, reflect: true })
], CDSSideNavMenuItem.prototype, "active", void 0);
__decorate([
    property()
], CDSSideNavMenuItem.prototype, "href", void 0);
__decorate([
    property()
], CDSSideNavMenuItem.prototype, "title", void 0);
CDSSideNavMenuItem = __decorate([
    carbonElement(`${prefix}-side-nav-menu-item`)
], CDSSideNavMenuItem);
var CDSSideNavMenuItem$1 = CDSSideNavMenuItem;

export { CDSSideNavMenuItem$1 as default };
//# sourceMappingURL=side-nav-menu-item.js.map
