/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement } from 'lit';
import { prefix } from '../../globals/settings.js';
import styles from './header.scss.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2023, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * A divider in switcher.
 *
 * @element cds-switcher-divider
 */
let CDSSwitcherDivider = class CDSSwitcherDivider extends LitElement {
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'separator');
        }
        super.connectedCallback();
    }
};
CDSSwitcherDivider.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
CDSSwitcherDivider = __decorate([
    carbonElement(`${prefix}-switcher-divider`)
], CDSSwitcherDivider);
var CDSSwitcherDivider$1 = CDSSwitcherDivider;

export { CDSSwitcherDivider$1 as default };
//# sourceMappingURL=switcher-divider.js.map
