/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { classMap } from 'lit/directives/class-map.js';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import { prefix } from '../../globals/settings.js';
import FocusMixin from '../../globals/mixins/focus.js';
import styles from './header.scss.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2019, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Switcher menu item.
 *
 * @element cds-switcher-item
 */
let CDSSwitcherItem = class CDSSwitcherItem extends FocusMixin(LitElement) {
    constructor() {
        super(...arguments);
        /**
         * Link `href`.
         */
        this.href = '';
        /**
         * Specify if this is a large variation of the side nav link
         */
        this.selected = false;
        /**
         * Specify if this is a large variation of the side nav link
         */
        this.tabIndex = 0;
    }
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'listitem');
        }
        super.connectedCallback();
    }
    render() {
        const { href, selected, ariaLabel, ariaLabelledBy, tabIndex } = this;
        const classes = classMap({
            [`${prefix}--switcher__item-link`]: true,
            [`${prefix}--switcher__item-link--selected`]: selected,
        });
        return html `
      <a
        part="link"
        aria-label="${ariaLabel}"
        aria-labelledby="${ariaLabelledBy}"
        tabindex="${tabIndex}"
        class="${classes}"
        href="${href}">
        <slot></slot>
      </a>
    `;
    }
};
CDSSwitcherItem.shadowRootOptions = Object.assign(Object.assign({}, LitElement.shadowRootOptions), { delegatesFocus: true });
CDSSwitcherItem.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ type: String, attribute: 'aria-label' })
], CDSSwitcherItem.prototype, "ariaLabel", void 0);
__decorate([
    property({ type: String, attribute: 'aria-labelledby' })
], CDSSwitcherItem.prototype, "ariaLabelledBy", void 0);
__decorate([
    property()
], CDSSwitcherItem.prototype, "href", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], CDSSwitcherItem.prototype, "selected", void 0);
__decorate([
    property({ type: Number, reflect: true, attribute: 'tab-index' })
], CDSSwitcherItem.prototype, "tabIndex", void 0);
CDSSwitcherItem = __decorate([
    carbonElement(`${prefix}-switcher-item`)
], CDSSwitcherItem);
var CDSSwitcherItem$1 = CDSSwitcherItem;

export { CDSSwitcherItem$1 as default };
//# sourceMappingURL=switcher-item.js.map
