/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { __decorate } from 'tslib';
import { LitElement, html } from 'lit';
import { property } from 'lit/decorators.js';
import { carbonElement } from '../../globals/decorators/carbon-element.js';
import styles from './header.scss.js';
import { prefix } from '../../globals/settings.js';

/**
 * @license
 *
 * Copyright IBM Corp. 2023, 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Switcher
 *
 * @element cds-switcher
 */
let CDSSwitcher = class CDSSwitcher extends LitElement {
    connectedCallback() {
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'list');
        }
        super.connectedCallback();
    }
    render() {
        return html `<slot></slot>`;
    }
};
CDSSwitcher.shadowRootOptions = Object.assign(Object.assign({}, LitElement.shadowRootOptions), { delegatesFocus: true });
CDSSwitcher.styles = styles; // `styles` here is a `CSSResult` generated by custom Vite loader
__decorate([
    property({ type: String, attribute: 'aria-label' })
], CDSSwitcher.prototype, "ariaLabel", void 0);
__decorate([
    property({ type: String, attribute: 'aria-labelledby' })
], CDSSwitcher.prototype, "ariaLabelledBy", void 0);
CDSSwitcher = __decorate([
    carbonElement(`${prefix}-switcher`)
], CDSSwitcher);
var CDSSwitcher$1 = CDSSwitcher;

export { CDSSwitcher$1 as default };
//# sourceMappingURL=switcher.js.map
