/**
 * @license
 *
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { ReactiveController, LitElement } from 'lit';
type PopoverControllerOptions = {
    target: HTMLElement;
    trigger: HTMLElement;
    arrowElement?: HTMLElement | undefined;
    alignment: string;
    flip: boolean;
    caret: boolean;
};
interface PopoverElement extends LitElement {
    open: boolean;
}
export default class PopoverController implements ReactiveController {
    /**
     * Host component
     */
    private host;
    /**
     * Floating-ui options to pass to `computePlacement()`
     */
    private options;
    /**
     * cleanup function to stop auto updates
     */
    private cleanup?;
    /**
     * register with host component
     * @param host host component
     */
    constructor(host: PopoverElement);
    setPlacement(options?: PopoverControllerOptions): Promise<void>;
    updatePlacement: () => void;
    computePlacement(): Promise<void>;
    hostUpdated(): void;
    hostDisconnected(): void;
}
export {};
