/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M30 9L28.0001 9 26 16 24.0001 9 22 9 25 17.9996 25 23 27 23 27 18 27.0001 18 30 9zM21 11L21 9 13 9 13 23 21 23 21 21 15 21 15 17 20 17 20 15 15 15 15 11 21 11zM11 9L8.8941 9 5 15.5527 5 9 3 9 3 23 5 23 5 18.7062 5.9277 17.2208 8.8941 23 11 23 7.1093 15.4308 11 9z"></path></svg>`;
export default svgResultCarbonIcon;