/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path d="M14 23H9a2 2 0 01-2-2V15a2 2 0 012-2h5v2H9v6h5zM24 9L16 9 16 11 22 11 16 21 16 23 24 23 24 21 18 21 24 11 24 9z"></path></svg>`;
export default svgResultCarbonIcon;