/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M12 28h-2c-3.8599 0-7-3.1401-7-7v-2h2v2c0 2.7568 2.2432 5 5 5h2v2zM28 19h-9c-1.104.0014-1.9986.896-2 2v5c0 1.1046.8954 2 2 2h3v-2h-3v-5h9v5h-2.5352l-2.5937 3.8906 1.6641 1.1094 2-3h1.4648c1.1046 0 2-.8954 2-2v-5c-.0014-1.104-.896-1.9986-2-2zM29 15v-4c0-3.8599-3.1401-7-7-7h-3v2h3c2.7568 0 5 2.2432 5 5v4h2zM6 10H9V12H6z"></path><path stroke-width="0" d="m12.606,6.4355l-2.5251-3.6855c-.3821-.4766-.9512-.75-1.5615-.75h-4.5193c-1.1028,0-2,.8975-2,2v10c0,1.1025.8972,2,2,2h7c1.1028,0,2-.8975,2-2v-6.375c0-.4526-.1558-.8965-.394-1.1895Zm-8.606,7.5645V4h4v3c0,.5522.4478,1,1,1h2v6h-7Z"></path></svg>`;
export default svgResultCarbonIcon;