/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M2.257 25.5H8.742V27.5H2.257z" transform="rotate(-45 5.5 26.5)"></path><path stroke-width="0" d="M9.257 18.5H15.742V20.5H9.257z" transform="rotate(-45 12.5 19.5)"></path><path stroke-width="0" d="M16.257 11.5H22.742V13.5H16.257z" transform="rotate(-45 19.5 12.5)"></path><path stroke-width="0" d="M23.257 4.5H29.742V6.5H23.257z" transform="rotate(-45 26.5 5.5)"></path></svg>`;
export default svgResultCarbonIcon;