/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path d="M7.0825 11.6714l-1.6748-1.0928c-.9062 1.3887-1.3928 3.2305-1.4072 5.3267l2 .0137c.0117-1.7119.3857-3.1807 1.082-4.2476zM6.0852 17.8164l-1.9907.1934c.1887 1.938.6592 3.6738 1.3982 5.1592l1.7905-.8911c-.6301-1.2661-1.0332-2.7676-1.198-4.4614zM8.2378 23.7964l-1.5688 1.2402c1.333 1.6865 3.0972 2.7573 4.8396 2.9375l.2061-1.9893c-1.1912-.1235-2.491-.9414-3.4768-2.1885zM16 25c-.7334 0-1.4783.271-2.1987.5332-.1809.0654-.3635.1318-.5469.1943l.6426 1.894c.197-.0669.3936-.1382.5879-.209.5576-.2026 1.134-.4126 1.5151-.4126.3809 0 .9575.21 1.5149.4121.1809.0659.3635.1323.5466.1953l.6479-1.8926c-.1711-.0586-.3418-.1206-.511-.1821-.7205-.2617-1.4653-.5327-2.1985-.5327zM20.2546 25.9878l.1855 1.9917c1.7456-.1631 3.5178-1.2227 4.8621-2.9072l-1.5632-1.2476c-.9924 1.2437-2.2949 2.0522-3.4844 2.1631zM24.7004 22.3115l1.7871.8975c.7449-1.4834 1.2205-3.2178 1.4138-5.1558l-1.9902-.1987c-.1689 1.6938-.5762 3.1934-1.2107 4.457zM28 15.9492c-.0076-2.0938-.4854-3.9365-1.3818-5.3311l-1.6821 1.082c.6897 1.0728 1.0576 2.5444 1.064 4.2559l2-.0068zM20 4h-1c-1.1046 0-2 .8954-2 2v1h1c1.1046 0 2-.8954 2-2v-1z"></path><path d="M23.8125,10.5308l1.1035-1.668c-.8655-.5728-1.8467-.8628-2.916-.8628-1.4155,0-2.4175,.2881-3.3013,.542-.5764,.1655-1.1362,.3203-1.7979,.4004-.502-2.8047-2.9541-4.9424-5.9009-4.9424v2c1.8223,0,3.3464,1.2319,3.8274,2.9014-.5442-.0864-1.031-.2173-1.5261-.3594-.8838-.2539-1.8857-.542-3.3013-.542-1.0693,0-2.0505,.29-2.916,.8628l1.1035,1.668c.5325-.3521,1.1423-.5308,1.8125-.5308,1.134,0,1.9185,.2256,2.7488,.4639,.917,.2637,1.8652,.5361,3.2512,.5361s2.3342-.2725,3.2512-.5361c.8303-.2383,1.6147-.4639,2.7488-.4639,.6702,0,1.28,.1787,1.8125,.5308Z"></path></svg>`;
export default svgResultCarbonIcon;