/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M2 3H30V5H2zM13 21H5c-1.1028 0-2-.8972-2-2v-6c0-1.1028.8972-2 2-2h8c1.1028 0 2 .8972 2 2v6c0 1.1028-.8972 2-2 2zM5 13v6h8v-6H5zM27 21h-8c-1.1028 0-2-.8972-2-2v-6c0-1.1028.8972-2 2-2h8c1.1028 0 2 .8972 2 2v6c0 1.1028-.8972 2-2 2zm-8-8v6h8v-6h-8zM2 27H30V29H2z"></path></svg>`;
export default svgResultCarbonIcon;