/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path d="M4,2h4v2h-4v4h-2v-4c0-1.1046.8954-2,2-2ZM28,2h-4v2h4v4h2v-4c0-1.1046-.8954-2-2-2ZM4,28v-4h-2v4c0,1.1046.8954,2,2,2h4v-2h-4ZM28,24v4h-4v2h4c1.1046,0,2-.8954,2-2v-4h-2ZM16,16c0-3.3137-2.6863-6-6-6s-6,2.6863-6,6,2.6863,6,6,6,6-2.6863,6-6ZM22,12c-2.2056,0-4,1.7944-4,4s1.7944,4,4,4,4-1.7944,4-4-1.7944-4-4-4M22,10c3.3137,0,6,2.6863,6,6s-2.6863,6-6,6-6-2.6863-6-6,2.6863-6,6-6h0Z"></path></svg>`;
export default svgResultCarbonIcon;