/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m28,4H4c-1.1045,0-2,.8955-2,2v20c0,1.1045.8955,2,2,2h24c1.1045,0,2-.8955,2-2V6c0-1.1045-.8955-2-2-2Zm0,2v12h-11v-6.1699s3.5898,3.5798,3.5898,3.5798l1.4102-1.4099-6-6-6,6,1.4102,1.4099,3.5898-3.5798v6.1699H4V6h24Z"></path></svg>`;
export default svgResultCarbonIcon;