/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path d="M30,25v-2h-2.1c-.1-.6-.4-1.2-.7-1.8l1.5-1.5-1.4-1.4-1.5,1.5c-.5-.3-1.1-.6-1.8-.7v-2.1h-2v2.1c-.6.1-1.2.4-1.8.7l-1.5-1.5-1.4,1.4,1.5,1.5c-.3.5-.6,1.1-.7,1.8h-2.1v2h2.1c.1.6.4,1.2.7,1.8l-1.5,1.5,1.4,1.4,1.5-1.5c.5.3,1.1.6,1.8.7v2.1h2v-2.1c.6-.1,1.2-.4,1.8-.7l1.5,1.5,1.4-1.4-1.5-1.5c.3-.5.6-1.1.7-1.8h2.1ZM23,27c-1.7,0-3-1.3-3-3s1.3-3,3-3,3,1.3,3,3-1.3,3-3,3ZM21.4854,7.126L12.4858,2.126c-.3027-.168-.6689-.168-.9717,0L2.5142,7.126c-.3174.1763-.5142.5107-.5142.874v10c0,.3633.1968.6982.5142.874l9,5c.1514.084.3188.126.4858.126.1753,0,.3506-.0459.5073-.1377.3052-.1797.4927-.5078.4927-.8623v-9.4116l7-3.8891v4.3007h2v-6c0-.3633-.1973-.6978-.5146-.874ZM12,4.144l6.9411,3.8561-6.9411,3.8558-6.9409-3.856,6.9409-3.856h0ZM4,17.4111v-7.7117l7,3.8889v7.7124s-7-3.8896-7-3.8896Z"></path></svg>`;
export default svgResultCarbonIcon;