/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<circle cx="7" cy="6" r="1" stroke-width="0"></circle><circle cx="11" cy="6" r="1" stroke-width="0"></circle><circle cx="28.5" cy="24.5" r="1.5" stroke-width="0"></circle><circle cx="23.5" cy="27.5" r="1.5" stroke-width="0"></circle><circle cx="18.5" cy="24.5" r="1.5" stroke-width="0"></circle><circle cx="18.5" cy="19.5" r="1.5" stroke-width="0"></circle><circle cx="23.5" cy="16.5" r="1.5" stroke-width="0"></circle><circle cx="28.5" cy="19.5" r="1.5" stroke-width="0"></circle><path stroke-width="0" d="m28,2H4c-1.1046,0-2,.8954-2,2v20c0,1.1046.8954,2,2,2h9v-2H4v-14h24v4h2V4c0-1.1046-.8954-2-2-2Zm0,6H4v-4h24v4Z"></path></svg>`;
export default svgResultCarbonIcon;