/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m22,16l-1.4141,1.4141,4.5859,4.5859h-10.1719V5c0-1.1046-.8954-2-2-2H3v2h10v17c0,1.1046.8954,2,2,2h10.1719l-4.5859,4.5859,1.4141,1.4141,7-7-7-7Z"></path></svg>`;
export default svgResultCarbonIcon;