/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<circle cx="22" cy="23" r="2" stroke-width="0"></circle><path stroke-width="0" d="m29.7769,22.4785c-1.2631-3.2173-4.3221-5.3723-7.7769-5.4785-3.4548.1062-6.5138,2.2612-7.7769,5.4785l-.2231.5215.2231.5215c1.2631,3.2173,4.3221,5.3723,7.7769,5.4785,3.4548-.1062,6.5138-2.2612,7.7769-5.4785l.2231-.5215-.2231-.5215Zm-7.7769,4.5215c-2.2091,0-4-1.7909-4-4s1.7909-4,4-4,4,1.7909,4,4c-.0025,2.2081-1.7919,3.9975-4,4Z"></path><path stroke-width="0" d="m12,28h-6c-1.1028,0-2-.8972-2-2V6c0-1.1028.8972-2,2-2h20c1.1028,0,2,.8972,2,2v10h-2V6H6v20h6v2Z"></path></svg>`;
export default svgResultCarbonIcon;