/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M30 23h-10c-1.1028 0-2-.8972-2-2v-10c0-1.1028.8972-2 2-2h10c1.1028 0 2 .8972 2 2v10c0 1.1028-.8972 2-2 2zm-10-12v10h10v-10h-10zM9 11L14 16 9 21 7.581 19.591 10.153 17 0 17 0 15 10.206 15 7.581 12.409 9 11z"></path></svg>`;
export default svgResultCarbonIcon;