/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m28,2v8h-4L16,2l-8,8h-4V2h-2v8c0,1.1025.8972,2,2,2h4l7,7v7.1719l-2.5859-2.5859-1.4141,1.4141,5,5,5-5-1.4141-1.4141-2.5859,2.5859v-7.1719l7-7h4c1.1028,0,2-.8975,2-2V2h-2Zm-12,15.1714l-6.1714-6.1714,6.1714-6.1714,6.1714,6.1714-6.1714,6.1714Z"></path></svg>`;
export default svgResultCarbonIcon;