/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m26,17h-10c-1.104.0014-1.9986.896-2,2v6c0,1.1046.8954,2,2,2h4v-2h-4v-6h10v6h-2.5352l-2.5937,3.8906,1.6641,1.1094,2-3h1.4648c1.1046,0,2-.8954,2-2v-6c-.0014-1.104-.896-1.9986-2-2Z"></path><path stroke-width="0" d="m22,14h2v-4c0-.2998-.1001-.5-.3-.7002l-7-7c-.2-.1997-.3999-.2998-.7-.2998H6c-1.1001,0-2,.8999-2,2v24c0,1.1001.8999,2,2,2h6v-2h-6V4h8v6c0,1.1001.8999,2,2,2h6v2Zm-6-4v-5.6001l5.6001,5.6001h-5.6001Z"></path></svg>`;
export default svgResultCarbonIcon;