/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path d="M21 28v2h-2c-1.1025 0-2-.8975-2-2v-2h2v2h2zM26 26h2v2c0 1.1025-.8975 2-2 2h-2v-2h2v-2zM24 21v-2h2c1.1025 0 2 .8975 2 2v2h-2v-2h-2zM19 23h-2v-2c0-1.1025.8975-2 2-2h2v2h-2v2z"></path><path d="M14,28h-6V4h8v6c0,1.1001.8999,2,2,2h6v4h2v-6c0-.2998-.1001-.5-.3-.7002l-7-7c-.2-.1997-.3999-.2998-.7-.2998h-10c-1.1001,0-2,.8999-2,2v24c0,1.1001.8999,2,2,2h6v-2ZM18,4.3999l5.6001,5.6001h-5.6001v-5.6001Z"></path></svg>`;
export default svgResultCarbonIcon;