/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M19.5328 16.0691c0-.9631.8772-1.4445 1.7885-1.4445 1.0486 0 1.4783.6532 1.4783 1.9257v5.4497h2.2004v-5.6732c0-2.2352-1.0315-3.5072-2.8712-3.5072-1.3922 0-2.1488.7395-2.5096 1.7021h-.0863v-1.4957h-2.2006v8.974h2.2006v-5.9309zM14.908 19.9883L9.2693 19.9883 9.2693 16.9282 14.2548 16.9282 14.2548 14.917 9.2693 14.917 9.2693 12.0117 14.908 12.0117 14.908 10 7 10 7 22 14.908 22 14.908 19.9883z"></path><path stroke-width="0" d="m21,30h-10c-4.9626,0-9-4.0374-9-9v-10C2,6.0374,6.0374,2,11,2h10c4.9626,0,9,4.0374,9,9v10c0,4.9626-4.0374,9-9,9ZM11,4c-3.8599,0-7,3.1401-7,7v10c0,3.8599,3.1401,7,7,7h10c3.8599,0,7-3.1401,7-7v-10c0-3.8599-3.1401-7-7-7h-10Z"></path></svg>`;
export default svgResultCarbonIcon;