/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path d="M17,19.9307a8,8,0,1,0-2,0V22H10v2h5v4h2V24h5V22H17ZM10,12a6,6,0,1,1,6,6A6.0066,6.0066,0,0,1,10,12Z"></path></svg>`;
export default svgResultCarbonIcon;