/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m23,29h-14c-.3555,0-.6846-.189-.8638-.4961L1.1362,16.5039c-.1816-.3113-.1816-.6965,0-1.0078L8.1362,3.4961c.1792-.3071.5083-.4961.8638-.4961h14c.3555,0,.6846.189.8638.4961l7,12c.1816.3113.1816.6965,0,1.0078l-7,12c-.1792.3071-.5083.4961-.8638.4961Zm-13.4258-2h12.8516l6.4165-11-6.4165-11h-12.8516l-6.4165,11,6.4165,11Z"></path></svg>`;
export default svgResultCarbonIcon;