/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m30.8508,15.4487l-6.9641-11.9165c-.1926-.3301-.5437-.5322-.9224-.5322h-13.9287c-.3787,0-.7297.2021-.9224.5322L1.1492,15.4487c-.199.3403-.199.7622,0,1.1025l6.9641,11.9165c.1926.3301.5437.5322.9224.5322h13.9287c.3787,0,.7297-.2021.9224-.5322l6.9641-11.9165c.199-.3403.199-.7622,0-1.1025Z"></path></svg>`;
export default svgResultCarbonIcon;