/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m3,23v-14c0-.3555.189-.6846.4961-.8638L15.4961,1.1362c.3113-.1816.6965-.1816,1.0078,0l12,7c.3071.1792.4961.5083.4961.8638v14c0,.3555-.189.6846-.4961.8638l-12,7c-.3113.1816-.6965.1816-1.0078,0l-12-7c-.3071-.1792-.4961-.5083-.4961-.8638Zm2-13.4258v12.8516l11,6.4165,11-6.4165v-12.8516l-11-6.4165-11,6.4165Z"></path></svg>`;
export default svgResultCarbonIcon;