/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path d="M28,11c-.75,0-1.39.4-1.73,1h-10.27c-2.21,0-4,1.79-4,4,0,.73.21,1.41.56,2h-6.83c-.34-.6-.98-1-1.73-1-1.12,0-2,.88-2,2s.88,2,2,2c.75,0,1.39-.4,1.73-1h10.27c2.21,0,4-1.79,4-4,0-.73-.21-1.41-.56-2h6.83c.34.6.98,1,1.73,1,1.12,0,2-.88,2-2s-.88-2-2-2ZM18,16c0,1.1-.9,2-2,2s-2-.9-2-2,.9-2,2-2,2,.9,2,2ZM5.05,15h-2c0-7.29,5.08-12,12.95-12h10v2h-10c-6.75,0-10.95,3.83-10.95,10ZM16.05,29H6.05v-2h10c6.14,0,10.95-4.39,10.95-10h2c0,6.73-5.69,12-12.95,12Z"></path></svg>`;
export default svgResultCarbonIcon;