/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path d="M16,21c-2.7568,0-5-2.2432-5-5s2.2432-5,5-5,5,2.2432,5,5-2.2432,5-5,5ZM16,13c-1.6543,0-3,1.3457-3,3s1.3457,3,3,3,3-1.3457,3-3-1.3457-3-3-3ZM27,25c0-1.1046-.8954-2-2-2s-2,.8954-2,2,.8954,2,2,2,2-.8954,2-2ZM5,7c0,1.1046.8954,2,2,2s2-.8954,2-2-.8954-2-2-2-2,.8954-2,2ZM30,16c0-7.7197-6.2803-14-14-14-1.8638,0-3.6758.3623-5.3857,1.0771l.7715,1.8457c1.4644-.6123,3.0166-.9229,4.6143-.9229,6.2803,0,11.4492,4.8496,11.959,11h-4.959v2h7v-1ZM21.3857,28.9229l-.7715-1.8457c-1.4639.6123-3.0166.9229-4.6143.9229-6.2798,0-11.4487-4.8496-11.9585-11h4.9585v-2H2v1c0,7.7197,6.2803,14,14,14,1.8643,0,3.6768-.3623,5.3857-1.0771Z"></path></svg>`;
export default svgResultCarbonIcon;