/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m29.9467,13.9356h-2c-.7368,0-1.3748.4051-1.7218,1H6.0151l2.625-7h7.3073v-2h-7.3073c-.8291,0-1.5811.521-1.873,1.2974l-2.5137,6.7026-2.3066-.0005v2l2,.0002v9.0002c0,1.103.8975,2,2,2v3h2v-3h16v3h2v-3c1.1025,0,2-.897,2-2v-9h2v-2ZM5.9467,24.9356v-3h3v-2h-3v-3h20v3h-3v2h3v3H5.9467Z"></path><path stroke-width="0" d="M11.979 19.941H19.979V21.941H11.979zM29.5367 2.5256L22.9467 9.1154 20.3567 6.5255 18.9467 7.9356 22.9467 11.9356 30.9467 3.9356 29.5367 2.5256z"></path></svg>`;
export default svgResultCarbonIcon;