/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m28,4h-3v1.9991l3-.0005v20.0015h-3v2h3c1.103,0,2-.897,2-2V6c0-1.103-.897-2-2-2Z"></path><circle cx="16" cy="17" r="2" stroke-width="0"></circle><path stroke-width="0" d="m22,4v24c0,1.103-.897,2-2,2H4c-1.103,0-2-.897-2-2V4c0-1.103.897-2,2-2h16c1.103,0,2,.897,2,2ZM4,28h16s0-24.0015,0-24.0015l-16,.0015v24Z"></path></svg>`;
export default svgResultCarbonIcon;