/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m16,30c-7.7197,0-14-6.2803-14-14h2c0,6.6167,5.3833,12,12,12s12-5.3833,12-12h2c0,7.7197-6.2803,14-14,14Z"></path><path stroke-width="0" d="m16,26c-5.5139,0-10-4.4861-10-10h2c0,4.4111,3.5889,8,8,8s8-3.5889,8-8h2c0,5.5139-4.4861,10-10,10Z"></path><path stroke-width="0" d="M16 20c-2.2056 0-4-1.7944-4-4s1.7944-4 4-4 4 1.7944 4 4-1.7944 4-4 4zm0-6c-1.103 0-2 .897-2 2s.897 2 2 2 2-.897 2-2-.897-2-2-2zM16 2c-4.9719 0-9.4933 2.6113-12 6.7883v-4.7883h-2v8h8v-2h-4.3881c2.126-3.6848 6.0558-6 10.3881-6 3.2051 0 6.2188 1.248 8.4854 3.5146l1.4141-1.4141c-2.644-2.6445-6.1597-4.1006-9.8994-4.1006z"></path></svg>`;
export default svgResultCarbonIcon;