/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path d="M17,27v-6h-2v4.6l-9.6-9.6L15,6.4v4.6h2v-6h10v8h2V5c0-1.1-.9-2-2-2H5c-1.1,0-2,.9-2,2v22c0,1.1.9,2,2,2h12v-2ZM5,5h8.6L5,13.6V5ZM5,27v-8.6l8.6,8.6H5ZM26.6,19l-3.7-3.7c-.2-.2-.4-.3-.6-.3h-3.5c-.6-1.6-2.3-2.4-3.8-1.8-.9.3-1.6,1-1.8,1.9-.5,1.6.4,3.3,2,3.7,1.5.5,3.1-.3,3.7-1.8h3l3.8,3.8c.1.1.3.2.5.2h3.9v-2s-3.5,0-3.5,0ZM16,17c-.6,0-1-.4-1-1s.4-1,1-1,1,.4,1,1-.4,1-1,1ZM24.8,23c-.4-1.2-1.5-2-2.8-2s-3,1.3-3,3,1.4,3,3,3,2.4-.8,2.8-2h5.2v-2h-5.2ZM22,25c-.5,0-1-.5-1-1s.5-1,1-1,1,.5,1,1-.4,1-1,1ZM26,27h4v2h-4v-2ZM28,15h2v2h-2v-2Z"></path></svg>`;
export default svgResultCarbonIcon;