/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="24" height="24" viewBox="0 0 32 32">${children}<path d="M29.9,16.4l-6,12c-.2.3-.5.6-.9.6h-13c-.6,0-1-.4-1-1s.4-1,1-1h12.4l5.5-11-5.5-11h-12.4c-.6,0-1-.4-1-1s.4-1,1-1h13c.4,0,.7.2.9.6l6,12c.1.3.1.6,0,.9h0v-.1ZM10,22c0,.6.4,1,1,1h11v-2h-11c-.6,0-1,.4-1,1ZM18,15H7c-.6,0-1,.4-1,1s.4,1,1,1h11v-2ZM22,11v-2h-11c-.6,0-1,.4-1,1s.4,1,1,1h11ZM3,15c-.6,0-1,.4-1,1s0,0,0,0h0c0,.6.4,1,1,1s1-.4,1-1,0,0,0,0h0c0-.6-.4-1-1-1ZM6,21c-.6,0-1,.4-1,1s.4,1,1,1,1-.4,1-1-.4-1-1-1ZM6,11c.6,0,1-.4,1-1s-.4-1-1-1-1,.4-1,1,.4,1,1,1Z"></path></svg>`;
export default svgResultCarbonIcon;