/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path d="M16,2c-7.7,0-14,6.3-14,14s2.7,9.5,6.7,12l1.1-1.7c-3.5-2.1-5.8-5.9-5.8-10.3,0-6.6,5.4-12,12-12s12,5.4,12,12h2c0-7.7-6.3-14-14-14ZM14,21.4l-5-5,1.4-1.4,3.6,3.6,7.6-7.6,1.4,1.4-9,9ZM29.2,27l-2.6,2.6,1.4,1.4,4-4-4-4-1.4,1.4,2.6,2.6ZM22.5,32l-1.9-.6,2.9-9.4,1.9.6-2.9,9.4ZM16.8,27l2.6-2.6-1.4-1.4-4,4,4,4,1.4-1.4-2.6-2.6Z"></path></svg>`;
export default svgResultCarbonIcon;