/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path d="M29,13h-2v-3.4257l-11-6.4166-3,1.7499v8.0924h-2V4.3333c0-.3557.189-.6846.4961-.8638l4-2.3333c.1558-.0908.3298-.1362.5039-.1362s.3481.0454.5039.1362l12,7c.3071.1792.4961.5081.4961.8638v4ZM7,16h2V6h-2v10ZM15,28.2718l-10.0013-5.8403v-13.4315h-1.9987v14.006c0,.3559.1889.6849.4958.8642l10.4971,6.1298,1.0072-1.7282h-.0001ZM26,17l-1.4141,1.4141,3.5854,3.5859-3.5854,3.5859,1.4141,1.4141,5-5-5-5ZM15,22l5,5,1.4141-1.4141-3.5854-3.5859,3.5854-3.5859-1.4141-1.4141-5,5Z"></path></svg>`;
export default svgResultCarbonIcon;