/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M2 9H6V11H2zM2 21H6V23H2zM25 11L23.5859 12.4141 26.1719 15 18 15 18 4 12 4 12 9 8 9 8 11 12 11 12 21 8 21 8 23 12 23 12 28 18 28 18 17 26.1719 17 23.5859 19.5859 25 21 30 16 25 11z"></path></svg>`;
export default svgResultCarbonIcon;