/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path d="M22.951 20h-2.1843c-.4141-1.1611-1.5137-2-2.8157-2s-2.4016.8389-2.8157 2H8.951v2h6.1843c.4141 1.1611 1.5137 2 2.8157 2s2.4016-.8389 2.8157-2h2.1843v-2Zm-5 2c-.5515 0-1-.4487-1-1s.4485-1 1-1 1 .4487 1 1-.4485 1-1 1Zm5-10h-6.1843c-.4141-1.1611-1.5137-2-2.8157-2s-2.4016.8389-2.8157 2H8.951v2h2.1843c.4141 1.1611 1.5137 2 2.8157 2s2.4016-.8389 2.8157-2h6.1843v-2Zm-9 2c-.5515 0-1-.4487-1-1s.4485-1 1-1 1 .4487 1 1-.4485 1-1 1Z"></path><path d="m29.8993 18.9897-2.593-11.1865a2 2 0 0 0-1.124-1.3711l-9.407-4.2544C16.5133 2.059 16.2321 2 15.9511 2s-.5623.0591-.8242.1777L5.7197 6.4321a2 2 0 0 0-1.124 1.3711l-2.593 11.1865a2.0008 2.0008 0 0 0 .3899 1.7056l6.886 8.5586A2.0001 2.0001 0 0 0 10.8367 30h10.2286a2.0001 2.0001 0 0 0 1.5581-.7461l6.886-8.5586a2.0008 2.0008 0 0 0 .3899-1.7056ZM21.0653 28H10.837l-6.886-8.5586 2.593-11.187L15.951 4l9.407 4.2549 2.593 11.1865L21.0652 28Z"></path><path fill="none" d="M0 0h32v32H0z"></path></svg>`;
export default svgResultCarbonIcon;