/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m16,2c-6.0654,0-11,4.936-11,11,0,2.3931.7656,4.6729,2.2163,6.5996,0,0,.3003.3945.3481.4517l8.4355,9.9487,8.439-9.9526c.0444-.0532.3447-.4478.3447-.4478l.0015-.0024c1.4492-1.9243,2.2148-4.2041,2.2148-6.5972,0-6.064-4.9346-11-11-11Zm-.5,4c.8284,0,1.5.6714,1.5,1.5s-.6716,1.5-1.5,1.5-1.5-.6714-1.5-1.5.6716-1.5,1.5-1.5Zm4.5,14h-8v-2h3v-5h-2v-2h4v7h3v2Z"></path><path fill="none" stroke-width="0" d="m15.5,6c.8284,0,1.5.6714,1.5,1.5s-.6716,1.5-1.5,1.5-1.5-.6714-1.5-1.5.6716-1.5,1.5-1.5Zm4.5,14h-8v-2h3v-5h-2v-2h4v7h3v2Z"></path></svg>`;
export default svgResultCarbonIcon;