/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="16" height="16" viewBox="0 0 32 32">${children}<path d="M26.1,5.7C23.5,2,18.4,0.9,14.7,3.2L8.2,7.4c-1.8,1.1-3,2.9-3.4,5c-0.3,1.7,0,3.5,0.8,5.1c-0.6,0.8-0.9,1.8-1.1,2.8	c-0.4,2.1,0.1,4.3,1.4,6c2.6,3.7,7.7,4.8,11.4,2.5l6.5-4.2c1.8-1.1,3-2.9,3.4-5c0.3-1.7,0-3.5-0.8-5.1c0.6-0.8,0.9-1.8,1.1-2.8	C27.9,9.6,27.4,7.4,26.1,5.7z M24.3,11c0,0.2-0.1,0.4-0.2,0.6L24,12l-0.3-0.2c-0.8-0.6-1.6-1-2.6-1.3l-0.2-0.1l0-0.2	c0-0.3-0.1-0.7-0.3-1c-0.4-0.5-1-0.8-1.7-0.6c-0.1,0-0.3,0.1-0.4,0.2L12,12.9c-0.3,0.2-0.5,0.5-0.6,0.9c-0.1,0.4,0,0.8,0.2,1.1	c0.4,0.5,1,0.8,1.7,0.6c0.1,0,0.3-0.1,0.4-0.2l2.5-1.6c0.4-0.3,0.9-0.5,1.3-0.6c2.1-0.5,4.3,0.3,5.6,2.1c0.7,1,1,2.4,0.8,3.6	c-0.2,1.2-1,2.3-2,3l-6.5,4.2c-0.4,0.3-0.9,0.5-1.3,0.6c-2.1,0.5-4.3-0.3-5.6-2.1c-0.7-1-1-2.4-0.8-3.6c0-0.2,0.1-0.4,0.2-0.6L8,20	l0.3,0.2c0.8,0.6,1.6,1,2.6,1.3l0.2,0.1l0,0.2c0,0.3,0.1,0.7,0.3,1c0.4,0.5,1,0.8,1.7,0.6c0.1,0,0.3-0.1,0.4-0.2l6.5-4.2	c0.3-0.2,0.5-0.5,0.6-0.9c0.1-0.4,0-0.8-0.2-1.1c-0.4-0.5-1-0.8-1.7-0.6c-0.1,0-0.3,0.1-0.4,0.2l-2.5,1.6c-0.4,0.3-0.9,0.5-1.3,0.6	c-2.1,0.5-4.3-0.3-5.6-2.1c-0.8-1-1-2.4-0.8-3.6c0.2-1.2,1-2.3,2-3l6.5-4.2c0.4-0.3,0.9-0.5,1.3-0.6c2.1-0.5,4.3,0.3,5.6,2.1	C24.2,8.5,24.5,9.8,24.3,11z"></path></svg>`;
export default svgResultCarbonIcon;