/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path stroke-width="0" d="M4 20L4 22 8.5859 22 2 28.5859 3.4141 30 10 23.4141 10 28 12 28 12 20 4 20z"></path><path stroke-width="0" d="m27,19c1.6543,0,3-1.3457,3-3s-1.3457-3-3-3c-1.302,0-2.4016.8385-2.8157,2h-5.7703l7.3005-7.3006c.3911.1871.8237.3006,1.2854.3006,1.6543,0,3-1.3457,3-3s-1.3457-3-3-3c-1.302,0-2.4016.8385-2.8157,2H7.8157c-.4141-1.1615-1.5137-2-2.8157-2-1.6543,0-3,1.3457-3,3s1.3457,3,3,3c.4617,0,.8943-.1135,1.2854-.3006l7.3005,7.3006h-5.7703c-.4141-1.1615-1.5137-2-2.8157-2-1.6543,0-3,1.3457-3,3v1h2v-1c0-.5513.4482-1,1-1s1,.4487,1,1v1h9.5859l8.7146,8.7147c-.0442.0927-.0815.1877-.1162.2853h-10.1843v2h10.1843c.4141,1.1615,1.5137,2,2.8157,2,1.6543,0,3-1.3457,3-3s-1.3457-3-3-3c-.4617,0-.8943.1135-1.2854.3006l-7.3005-7.3006h5.7703c.4141,1.1615,1.5137,2,2.8157,2Zm1,8c0,.5513-.4482,1-1,1s-1-.4487-1-1,.4482-1,1-1,1,.4487,1,1Zm-1-12c.5518,0,1,.4487,1,1s-.4482,1-1,1-1-.4487-1-1,.4482-1,1-1ZM7.8157,6h16.3687c.0349.0976.072.1927.1162.2853l-8.3005,8.3006L7.6995,6.2853c.0442-.0927.0815-.1877.1162-.2853Zm19.1843-2c.5518,0,1,.4487,1,1s-.4482,1-1,1-1-.4487-1-1,.4482-1,1-1ZM4,5c0-.5513.4482-1,1-1s1,.4487,1,1-.4482,1-1,1-1-.4487-1-1Z"></path></svg>`;
export default svgResultCarbonIcon;