/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="32" height="32" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m27,12v15H5V5h15v-2H5c-1.1046,0-2,.8954-2,2v22c0,1.1046.8954,2,2,2h22c1.1046,0,2-.8954,2-2v-15h-2Z"></path><circle cx="26.5" cy="5.5" r="3.5" stroke-width="0"></circle></svg>`;
export default svgResultCarbonIcon;