/**
 * Copyright IBM Corp. 2024
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

import { svg } from 'lit';
import spread from '../../globals/directives/spread.js';

const svgResultCarbonIcon = ({ children, ...attrs } = {}) => svg`<svg focusable="false" preserveAspectRatio="xMidYMid meet" xmlns="http://www.w3.org/2000/svg" fill="currentColor" ...="${spread(attrs)}" aria-hidden="true" width="20" height="20" viewBox="0 0 32 32">${children}<path stroke-width="0" d="m28,28H4c-1.1028,0-2-.8972-2-2V6c0-1.1028.8972-2,2-2h10c1.1028,0,2,.8972,2,2v4h12c1.1028,0,2,.8972,2,2v14c0,1.1028-.8972,2-2,2ZM4,12v14h24v-14H4Zm0-2h10v-4H4v4Z"></path></svg>`;
export default svgResultCarbonIcon;